﻿<?LassoScript
encode_set: -encodenone;

/*
<fusedoc fuse="fbx_CustomTags.inc" language="Lasso" specification="3.0">
	<responsibilities>
		I hold the user defined custom tags used within the application. There should be only one fbx_CustomTags.inc file within the application and it should reside within the root folder.
	</responsibilities>	
	<properties>
		<history author="Tami Williams" date="May 2003" email="tami@asktami.com" type="Create" />
		<history author="Tami Williams" date="May 2008" email="tami@asktami.com" type="Update" />
	</properties>
</fusedoc>
*/

//

// example custom tag
Define_Tag: 'MyFirstTag';
  	return: 'Hello World!' ;
/Define_Tag;


//


// LogClientParams Custom Tag v1
// Author Tami Williams
// URL http://www.asktami.com/
// for Lasso Professional 6 & 7 & 8

// Inside an Inline use:  [LogClientParams: (client_postparams) ]
// Outside an inline use: [LogClientParams]

/*
with lassoFusebox MUST put at top of site.lasso file OR at top of individual fbx_Switch.inc files (or at least BEFORE the redirect_url)!
use like this (at the bottom of site.lasso and at the top of any fbx_Switch.inc)

[output_none]
Log Fields:
Date	SessionID	Referrer_URL	Server_Name	Server_Time	Client_IP	Client_Browser	Response_FilePath	Client_GetArgs	Client_PostArgs	var:'pid'	var:'lid'	Error_CurrentError: -ErrorCode	Error_CurrentError+errCkVariables
[/output_none]

[encode_set: -encodenone]
[Variable: 'Log_File' ='logs/' + (Server_Date: -Extended) + '_SessionLog.txt']
[Log: (Variable: 'Log_File')][Date_Format: (Date), -Format='%D']	[Session_ID: -Name=(var:'sessionName')]	[Referrer_URL]	[Server_Name]	[Server_Time]	[Client_IP]		[Client_Browser]	[Response_FilePath]	[Client_GetArgs]	[Client_PostArgs]	[var:'pid']	[var:'lid']	[Error_CurrentError: -ErrorCode]	[Error_CurrentError] | errckAction = [$errckAction] | errckFound = [$errckFound] | errckCode = [$errckCode] | errckError = [$errckError] | errckDbname = [$errckDbname] | errckTblname = [$errckTblname] | feedback = [$feedback] | logMessage = [$logMessage] | [LogClientParams]
[/Log]
[/encode_set]
*/

if: !(lasso_tagexists:'LogClientParams');
Define_Tag: 'LogClientParams', -Optional='TheParamsX', -priority='Replace';
local: 'Output' = '' ;

if: (Params->(size)) == 0;
local: 'TheParams' = @($myclientparams);
else;
local: 'TheParams' = (Params->(Get:1)) ;
/if;

iterate: (#TheParams), (local:'temp' );
	 if: !#Output ;
		 #Output = 'LogClientParams = ' (#temp->first) + ' = ' + encode_html(#temp->second);
	 else;
		 #Output += ', ' + (#temp->first) + ' = ' + encode_html(#temp->second);
	 /if;
/iterate;

return: @#Output;
/Define_Tag;
/if;


//


/*----------------------------------------------------------------------------
[lp_client_isBot]
Returns true if client is a bot, spider, validator, robot or crawler.

Author: Bil Corry
Last Modified: May. 03, 2006
License: Public Domain

Description:
Returns true if client is a bot, spider, validator, robot or crawler.  It's 
based on user-agent, so it won't identify any bot that doesn't identify itself 
via the user-agent.


Sample Usage:
if: lp_client_isBot;
'Hello automated friend!';
/if;


Downloaded from tagSwap.net on Jun. 27, 2007.
Latest version available from <http://tagSwap.net/lp_client_isBot>.

----------------------------------------------------------------------------
*/
		
define_tag: 'lp_client_isBot',
	-description='Returns true if client is a bot, spider, validator, robot or crawler.',
	-priority='replace',
	-optional='user_agent';

	// based on a tag from Fletcher Sandbeck

	// http://www.pgts.com.au/pgtsj/pgtsj0212d.html

	if: local_defined:'user_agent';
		local:'client_browser' = #user_agent;
	else;
		local:'client_browser' = client_browser;
	/if;

	local: 'bots' = (array:
						'bot',
						'slurp',
						'crawler',
						'spider',
						'search',
						'checker',
						'creep',
						'robo',
						'worm',
						'leech',
						'validator',
						'siphon',
						'index',
						'Mediapartners-Google',
						'LinksManager',
						'ia_archiver',
						'Jeeves',
						'AvantGo',
						'ASPseek',
						'Appie',
						'Findlinks',
						'Httpget',
						'Grub',
						'Infoseek',
						'Larbin',
						'Scooter',
						'Scrubby',
						'Xenu',
						'wGet',
						'Sitecheck',
						'URL Control',
						'Knowledge',
						'InternetLinkAgent',
						'IlTrovatore',
						'LinkLint',
						'Internet Publishing Provider',
						'java',
						'php',
						'perl',
						'python',
						'lasso',
						'curl',
						'feed'						
	  				);

	iterate: #bots, (local: 'bot');
    	if: #client_browser->(contains:#bot);
			return: true;
		/if;
	/iterate;

	return: false;

/define_tag;


//


// INCLUDETHIS
// a custom tag so I don't have to keep writing: 
// $layout = include: $currentPath +  'thisfilename.inc' ;
// Example: includethis: 'filename' ;

if: !(lasso_tagexists:'includethis');
define_tag:'includethis', -required='filename';
$layout = include: $currentpath + #filename ;
return: @$layout;
/define_tag;
/if;


//


// INCLUDETHAT
// a custom tag so I don't have to keep writing: 
// $layout = include: '_common/thisfilename.inc' ;
// for including files from the application's root/_common folder
// Example: includethat: 'filename' ;

if: !(lasso_tagexists:'includethat');
define_tag:'includethat', -required='filename';
$layout = include:  '_common/' + #filename;
return: @$layout;
/define_tag;
/if;


//


// a custom tag to create unique IDs from greg willits
// Example: [makeID: 9]

if: !(lasso_tagexists:'makeID');
define_tag:'makeID', -required='idLen';
local: 'idVal'='',
		 'srcChars'='AaBb9CcDd8EeFf7GgHh6iJj5KkLMm4NnPp3QqRr2SsTt1UuVv9WwXx8YyZz';
	
local: 'srcLen'=(string_length: (#srcChars));

	loop: #idLen;
		#idVal += (#srcChars)->(substring:(math_random: -min=1, -max=#srcLen),1);
	/loop;

return: #idVal;
/define_tag;
/if;


//


// a custom tag to create unique IDs from greg willits  MODIFIED
// Example: [makepassword: 9]

if: !(lasso_tagexists:'makepassword');
define_tag:'makepassword', -required='passwordLen';
local: 'passwordtemp' = '',
		 'passwordfinal' = '',
		 'srcChars'='AaBbCcDdEeFfGgHhiJjKkLMmNnPpQqRrSsTtUuVvWwXxYyZz';
	
local: 'srcLen'=(string_length: (#srcChars));

	loop: #passwordLen;
		#passwordtemp += (#srcChars)->(substring:(math_random: -min=1, -max=#srcLen),1);
	/loop;

#passwordfinal = (String_Concatenate: (Math_Random: -Lower=1, -Upper=9), (Math_Random: -Lower=1, -Upper=9), (#passwordtemp), (Math_Random: -Lower=1, -Upper=9), (Math_Random: -Lower=1, -Upper=9) );
return: #passwordfinal;
/define_tag;
/if;


//


// FirstUpper Custom Tag v2
// Author Tami Williams (modified the "FirstUpper Custom Tag v1" tag created by Duncan Cameron obtained from www.lassoscripts.com)
// URL http://www.asktami.com/
// for Lasso Professional 6 & 7 & 8

// Examples:
// [FirstUpper: 'string']
// [FirstUpper: (Field: 'this_field')]
// [FirstUpper: (Action_Param: 'this_field')]
// [FirstUpper: $variable]

/*
The FirstUpper Custom Tag allows a string to be passed and have the string converted so that the first letter of the first word is in uppercase and the remainder of the string in lowercase.  It does not modify the existing variable if a variable is passed to the tag.

Input: [FirstUpper: 'make it so']
Output: Make it so

Input: [FirstUpper: 'make_It SO']
Output: Make it so
*/

if: !(lasso_tagexists:'FirstUpper');
Define_Tag: 'FirstUpper', -Required = 'XSentence',  -Priority='Replace';
Local: 'Sentence' = (string: #XSentence) ;
Local: 'Temp' = (String_Replace: #Sentence, -Find=' ', -Replace='' );

// replace all underscores with spaces
#Sentence =(String_Replace: #Sentence, -Find='_', -Replace=' ' );

if: !#Temp;
	Return: #Temp;
	
else;
	(#Sentence)->Trim;
	
	local: 'FirstLetter' = @(#Sentence)->(Get:1);
	
	#Sentence = (String_Uppercase: #FirstLetter) +  (String_Lowercase: (String_Remove: (#Sentence), -StartPosition=1, -EndPosition=1) );
	
	Return: #Sentence;
/if;
	
/Define_Tag;
/if;


//


// ************************************************************************************************************************
// MakeVarsFromActionParams Custom Tag v1
// Author Tami Williams
// URL http://www.asktami.com/
//	for Lasso Professional 6 & 7 & 8

// Example: [MakeVarsFromActionParams]
// Example: [MakeVarsFromActionParams: (action_params)]


if: !(lasso_tagexists:'MakeVarsFromActionParams');
Define_Tag: 'MakeVarsFromActionParams', -Optional='TheParams', -priority='Replace';

if: (Params->(size)) == 0;
local: 'TheParams' = @($myparams);
/if;

iterate: (#TheParams), (local:'temp' );
if: !((#temp ->first) -> (BeginsWith: '_'))  &&  !((#temp ->first) -> (BeginsWith: '-')) ;
		   var: #temp->first = encode_sql(action_param:(#temp->second)) ;
/if;

/iterate;
/Define_Tag;
/if;


//


// MakeVarsFromClientParams Custom Tag v1
// Author Tami Williams
// URL http://www.asktami.com/
//	for Lasso Professional 6 & 7 & 8

// Example: [MakeVarsFromClientParams]
// Example: [MakeVarsFromClientParams: (client_postparams)]

if: !(lasso_tagexists:'MakeVarsFromClientParams');
Define_Tag: 'MakeVarsFromClientParams', -Optional='TheParams', -priority='Replace';

if: (Params->(size)) == 0;
local: 'TheParams' = @($myclientparams);
/if;

loop: (#TheParams)->size ;

if: !(#TheParams)->(get: loop_count)->first->(BeginsWith: '_' )   &&  !(#TheParams)->(get: loop_count)->first->(BeginsWith: '-' ) ;
var: (#TheParams)->(get: loop_count)->first = encode_sql((#TheParams)->(get: loop_count)->second) ;
/if;

/loop;

/Define_Tag;
/if;



//


// ShowClientParams Custom Tag v1
// Author Tami Williams
// URL http://www.asktami.com/
// for Lasso Professional 6 & 7 & 8

// Inside an Inline use:  [ShowClientParams: (client_postparams) ]
// Outside an inline use: [ShowClientParams]

if: !(lasso_tagexists:'ShowClientParams');
Define_Tag: 'ShowClientParams', -Optional='TheParamsX', -priority='Replace';
local: 'Output' = (array) ;

if: (Params->(size)) == 0;
local: 'TheParams' = @($myclientparams);
else;
local: 'TheParams' = (Params->(Get:1)) ;
/if;

#Output =  '<b>ShowClientParams - Form Entries:</b>' ;

	iterate: (#TheParams), (local:'temp' );
	#Output +=  '<br />' + (#temp->first) + ' = ' + encode_html(#temp->second);
	/iterate;

return: @#Output;
/Define_Tag;
/if;



//


// ShowVars Custom Tag v1
// Author Tami Williams
// URL http://www.asktami.com/
//	for Lasso Professional 6 & 7 & 8

// Example:  [ShowVars]

if: !(lasso_tagexists:'ShowVars');
Define_Tag: 'ShowVars', -Optional='TheVars', -priority='Replace';
local: 'Output' = (string) ;

if: (Params->(size)) == 0;
local: 'TheVars' = (variables);
/if;
 

#Output +=  '<b>ShowVars:</b>' ;

loop: (#TheVars)->size;
if: ! (#TheVars)->(get: loop_count)->first->(BeginsWith: '_' )  &&   ! (#TheVars)->(get: loop_count)->first->(BeginsWith: 'myparams' )  &&  ! (#TheVars)->(get: loop_count)->first->(BeginsWith: 'myclientparams' )  &&  ! (#TheVars)->(get: loop_count)->first->(BeginsWith: 'variables' );
#Output +=  '<br />' +  (#TheVars)->(get: loop_count)->first + '  = ' + encode_html((#TheVars)->(get: loop_count)->second);
/if;
/loop;

return: @#Output;
/Define_Tag;
/if;

/encode_set;
?>